#include "DMD_Semesin.h"


// Port registers are same size as a pointer (16-bit on AVR, 32-bit on ARM)
//typedef intptr_t port_reg_t;

SPIDMD::SPIDMD(byte panelsWide, byte panelsHigh)
#ifdef ESP8266
  : HUB12(panelsWide, panelsHigh, 0, 2, 15, 12)
  // : HUB12(panelsWide, panelsHigh, 15, 16, 12, 0)
#else
  : HUB12(panelsWide, panelsHigh, 9, 6, 7, 8)
#endif
{
}

/* Create a DMD display using a custom pinout for all the non-SPI pins (SPI pins set by hardware) */
SPIDMD::SPIDMD(byte panelsWide, byte panelsHigh, byte pin_noe, byte pin_a, byte pin_b, byte pin_sck)
  : HUB12(panelsWide, panelsHigh, pin_noe, pin_a, pin_b, pin_sck)
{
}

void SPIDMD::beginNoTimer()
{
  // Configure SPI before initialising the base DMD
  pinMode(SS, OUTPUT);

  SPI.begin();
  SPI.setBitOrder(MSBFIRST);
  SPI.setDataMode(SPI_MODE0);  // CPOL=0, CPHA=0
  SPI.setClockDivider(SPI_CLOCK_DIV4); // 4MHz clock. 8MHz (DIV2 not DIV4) is possible if you have short cables. Longer cables may need DIV8/DIV16.

  HUB12::beginNoTimer();
}

void SPIDMD::writeSPIData(volatile uint8_t *rows[4], uint8_t rowsize)
{
  /* We send out interleaved data for 4 rows at a time */
  for (int i = 0; i < rowsize; i++) {
#ifdef __AVR__
#if breakOnSerial
#if pakaiSerialPort == 0
#if defined(UBRRH) && defined(UBRRL)
    if (UCSRA & (1 << RXC))
    {
      return true;
    }
#else
    if (UCSR0A & (1 << RXC0))
    {
      return true;
    }
#endif
#elif pakaiSerialPort == 1
    if (UCSR1A & (1 << RXC1))
    {
      return true;
    }
#endif
#endif
#endif

			
    SPI.transfer(*(rows[3]++));
    SPI.transfer(*(rows[2]++));
    SPI.transfer(*(rows[1]++));
    SPI.transfer(*(rows[0]++));

  }
}

#ifdef ESP8266
// No SoftDMD for ESP8266 for now
#endif

//========================================================================================================
HUB12::HUB12(byte panelsWide, byte panelsHigh, byte pin_noe, byte pin_a, byte pin_b, byte pin_sck)
  :
  DMDFrame(panelsWide * 32, panelsHigh * 16),
  // backGround(panelsWide*PANEL_WIDTH, panelsHigh*PANEL_HEIGHT),
  scan_row(0),
  pin_noe(pin_noe),
  pin_a(pin_a),
  pin_b(pin_b),
  pin_sck(pin_sck),
#ifdef ESP8266
  default_pins(pin_noe == 15 && pin_a == 16 && pin_b == 12 && pin_sck == 0)
#else
  default_pins(pin_noe == 9 && pin_a == 6 && pin_b == 7 && pin_sck == 8)
#endif
{
}

void HUB12::scanDisplay()
{
	// Serial.println("s");
  uint8_t rowsize = unified_width_bytes();

  volatile uint8_t *rows[4] = { // Scanning out 4 interleaved rows
    bitmap + (scan_row + 0) * rowsize,
    bitmap + (scan_row + 4) * rowsize,
    bitmap + (scan_row + 8) * rowsize,
    bitmap + (scan_row + 12) * rowsize,
  };
  
  writeSPIData(rows, widthBytesToShow);

  digitalWrite(pin_noe, LOW);
  digitalWrite(pin_sck, HIGH); // Latch DMD shift register output
  digitalWrite(pin_sck, LOW); // (Deliberately left as digitalWrite to ensure decent latching time)

  // Digital outputs A, B are a 2-bit selector output, set from the scan_row variable (loops over 0-3),
  // that determines which set of interleaved rows we are outputting during this pass.
  // BA 0 (00) = 1,5,9,13
  // BA 1 (01) = 2,6,10,14
  // BA 2 (10) = 3,7,11,15
  // BA 3 (11) = 4,8,12,16
  digitalWrite(pin_a, scan_row & 0x01);
  digitalWrite(pin_b, scan_row & 0x02);
  scan_row = (scan_row + 1) % 4;
  analogWrite(pin_noe, brightness);
  scanningFlag = false;
}

void HUB12::beginNoTimer()
{
  digitalWrite(pin_noe, LOW);
  pinMode(pin_noe, OUTPUT);

  digitalWrite(pin_a, LOW);
  pinMode(pin_a, OUTPUT);

  digitalWrite(pin_b, LOW);
  pinMode(pin_b, OUTPUT);

  digitalWrite(pin_sck, LOW);
  pinMode(pin_sck, OUTPUT);
}

//=======================================================
